/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec;

import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import sun.security.ec.ECKeyFactory;
import sun.security.ec.ECPublicKeyImpl;
import sun.security.util.ECUtil;

public final class ECDHKeyAgreement
extends KeyAgreementSpi {
    private ECPrivateKey privateKey;
    private byte[] publicValue;
    private int secretLen;

    @Override
    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException("Key must be instance of PrivateKey");
        }
        this.privateKey = (ECPrivateKey)ECKeyFactory.toECKey(key);
        this.publicValue = null;
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        this.engineInit(key, secureRandom);
    }

    @Override
    protected Key engineDoPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        if (this.privateKey == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.publicValue != null) {
            throw new IllegalStateException("Phase already executed");
        }
        if (!bl) {
            throw new IllegalStateException("Only two party agreement supported, lastPhase must be true");
        }
        if (!(key instanceof ECPublicKey)) {
            throw new InvalidKeyException("Key must be a PublicKey with algorithm EC");
        }
        ECPublicKey eCPublicKey = (ECPublicKey)key;
        ECParameterSpec eCParameterSpec = eCPublicKey.getParams();
        this.publicValue = eCPublicKey instanceof ECPublicKeyImpl ? ((ECPublicKeyImpl)eCPublicKey).getEncodedPublicValue() : ECUtil.encodePoint(eCPublicKey.getW(), eCParameterSpec.getCurve());
        int n = eCParameterSpec.getCurve().getField().getFieldSize();
        this.secretLen = n + 7 >> 3;
        return null;
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (this.privateKey == null || this.publicValue == null) {
            throw new IllegalStateException("Not initialized correctly");
        }
        byte[] byArray = this.privateKey.getS().toByteArray();
        byte[] byArray2 = ECUtil.encodeECParameterSpec(null, this.privateKey.getParams());
        try {
            return ECDHKeyAgreement.deriveKey(byArray, this.publicValue, byArray2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ProviderException("Could not derive key", generalSecurityException);
        }
    }

    @Override
    protected int engineGenerateSecret(byte[] byArray, int n) throws IllegalStateException, ShortBufferException {
        if (n + this.secretLen > byArray.length) {
            throw new ShortBufferException("Need " + this.secretLen + " bytes, only " + (byArray.length - n) + " available");
        }
        byte[] byArray2 = this.engineGenerateSecret();
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    @Override
    protected SecretKey engineGenerateSecret(String string) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        if (string == null) {
            throw new NoSuchAlgorithmException("Algorithm must not be null");
        }
        if (!string.equals("TlsPremasterSecret")) {
            throw new NoSuchAlgorithmException("Only supported for algorithm TlsPremasterSecret");
        }
        return new SecretKeySpec(this.engineGenerateSecret(), "TlsPremasterSecret");
    }

    private static native byte[] deriveKey(byte[] var0, byte[] var1, byte[] var2) throws GeneralSecurityException;
}

