/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.security.ucrypto;

import com.oracle.security.ucrypto.NativeCipher;
import com.oracle.security.ucrypto.UcryptoException;
import com.oracle.security.ucrypto.UcryptoProvider;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;

final class CipherContextRef
extends PhantomReference<NativeCipher>
implements Comparable<CipherContextRef> {
    private static ReferenceQueue<NativeCipher> refQueue = new ReferenceQueue();
    private static Set<CipherContextRef> refList = new ConcurrentSkipListSet<CipherContextRef>();
    final long id;
    final boolean encrypt;

    private static void drainRefQueueBounded() {
        CipherContextRef cipherContextRef;
        while ((cipherContextRef = (CipherContextRef)refQueue.poll()) != null) {
            cipherContextRef.dispose(true);
        }
    }

    CipherContextRef(NativeCipher nativeCipher, long l, boolean bl) {
        super(nativeCipher, refQueue);
        this.id = l;
        this.encrypt = bl;
        refList.add(this);
        UcryptoProvider.debug("Resource: trace CipherCtxt " + this.id);
        CipherContextRef.drainRefQueueBounded();
    }

    @Override
    public int compareTo(CipherContextRef cipherContextRef) {
        if (this.id == cipherContextRef.id) {
            return 0;
        }
        return this.id < cipherContextRef.id ? -1 : 1;
    }

    void dispose(boolean bl) {
        refList.remove(this);
        try {
            if (bl) {
                UcryptoProvider.debug("Resource: cancel CipherCtxt " + this.id);
                int n = NativeCipher.nativeFinal(this.id, this.encrypt, null, 0);
                if (n < 0) {
                    UcryptoProvider.debug("Resource: error cancelling CipherCtxt " + this.id + " " + new UcryptoException(-n).getMessage());
                }
            } else {
                UcryptoProvider.debug("Resource: untrace CipherCtxt " + this.id);
            }
        }
        finally {
            this.clear();
        }
    }
}

