/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.security.ucrypto;

import com.oracle.security.ucrypto.Config;
import com.oracle.security.ucrypto.UcryptoException;
import com.oracle.security.ucrypto.UcryptoMech;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.util.HashMap;
import java.util.StringTokenizer;
import sun.security.action.GetPropertyAction;
import sun.security.action.PutAllAction;

public final class UcryptoProvider
extends Provider {
    private static final long serialVersionUID = 351251234302833L;
    private static boolean DEBUG;
    private static HashMap<String, String> provProp;
    static Provider provider;

    private static native boolean[] loadLibraries();

    private static native String getMechList();

    static void debug(String string) {
        if (DEBUG) {
            System.out.println("UCrypto/" + string);
        }
    }

    public UcryptoProvider() {
        super("OracleUcrypto", 1.8, "Provider using Oracle Ucrypto API");
        if (provProp != null) {
            AccessController.doPrivileged(new PutAllAction(this, provProp));
        }
        if (provider == null) {
            provider = this;
        }
    }

    public UcryptoProvider(String string) {
        super("OracleUcrypto", 1.8, "Provider using Oracle Ucrypto API");
        try {
            if (provProp != null) {
                HashMap<String, String> hashMap = new HashMap<String, String>(provProp);
                Config config = new Config(string);
                String[] stringArray = config.getDisabledServices();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (hashMap.remove(stringArray[i]) != null) {
                        UcryptoProvider.debug("Prov: remove config-disabled service " + stringArray[i]);
                        continue;
                    }
                    UcryptoProvider.debug("Prov: ignore unsupported config-disabled service " + stringArray[i]);
                }
                AccessController.doPrivileged(new PutAllAction(this, hashMap));
            }
        }
        catch (IOException iOException) {
            throw new UcryptoException("Error parsing Config", iOException);
        }
        if (provider == null) {
            provider = this;
        }
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    static {
        try {
            DEBUG = Boolean.parseBoolean(AccessController.doPrivileged(new GetPropertyAction("com.oracle.security.ucrypto.debug")));
            provProp = AccessController.doPrivileged(new PrivilegedAction<HashMap<String, String>>(){

                @Override
                public HashMap<String, String> run() {
                    try {
                        System.loadLibrary("j2ucrypto");
                        String string = System.getProperty("os.name");
                        if (string.startsWith("SunOS")) {
                            return new HashMap<String, String>();
                        }
                        return null;
                    }
                    catch (Error error) {
                        return null;
                    }
                    catch (SecurityException securityException) {
                        return null;
                    }
                }
            });
            if (provProp != null) {
                boolean[] blArray = UcryptoProvider.loadLibraries();
                if (blArray.length == 2) {
                    if (blArray[0]) {
                        provProp.put("MessageDigest.MD5", "com.oracle.security.ucrypto.NativeDigest$MD5");
                        provProp.put("MessageDigest.SHA", "com.oracle.security.ucrypto.NativeDigest$SHA1");
                        provProp.put("Alg.Alias.MessageDigest.SHA-1", "SHA");
                        provProp.put("Alg.Alias.MessageDigest.SHA1", "SHA");
                        provProp.put("MessageDigest.SHA-256", "com.oracle.security.ucrypto.NativeDigest$SHA256");
                        provProp.put("Alg.Alias.MessageDigest.2.16.840.1.101.3.4.2.1", "SHA-256");
                        provProp.put("Alg.Alias.MessageDigest.OID.2.16.840.1.101.3.4.2.1", "SHA-256");
                        provProp.put("MessageDigest.SHA-384", "com.oracle.security.ucrypto.NativeDigest$SHA384");
                        provProp.put("Alg.Alias.MessageDigest.2.16.840.1.101.3.4.2.2", "SHA-384");
                        provProp.put("Alg.Alias.MessageDigest.OID.2.16.840.1.101.3.4.2.2", "SHA-384");
                        provProp.put("MessageDigest.SHA-512", "com.oracle.security.ucrypto.NativeDigest$SHA512");
                        provProp.put("Alg.Alias.MessageDigest.2.16.840.1.101.3.4.2.3", "SHA-512");
                        provProp.put("Alg.Alias.MessageDigest.OID.2.16.840.1.101.3.4.2.3", "SHA-512");
                    }
                    if (blArray[1]) {
                        String string = UcryptoProvider.getMechList();
                        UcryptoProvider.debug("Prov: supported mechs = " + string);
                        for (UcryptoMech ucryptoMech : UcryptoMech.values()) {
                            String[] stringArray;
                            if (string.indexOf(ucryptoMech.name() + ",") == -1 || (stringArray = ucryptoMech.jceProperties()) == null) continue;
                            for (int i = 0; i < stringArray.length; ++i) {
                                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i], ";");
                                if (stringTokenizer.countTokens() != 2) {
                                    throw new RuntimeException("Wrong format: " + stringArray[i]);
                                }
                                provProp.put(stringTokenizer.nextToken(), stringTokenizer.nextToken());
                            }
                        }
                        provProp.put("AlgorithmParameters.GCM", "com.oracle.security.ucrypto.GCMParameters");
                    }
                } else {
                    UcryptoProvider.debug("Prov: unexpected ucrypto library loading error, got " + blArray.length);
                }
            }
        }
        catch (AccessControlException accessControlException) {
            DEBUG = false;
            provProp = null;
        }
        provider = null;
    }
}

